# Define path to LightScribe installation
lspath=/usr/lib/lightscribe

# Define the output strings
outputStr[0]=Enhanced
outputStr[1]=Default

# Define directory names
dirStr[0]=xres
dirStr[1]=sres

# Define symbolic link name
symlinkStr=res

# Ensure superuser status
touch ${lspath}/noexist 1>/dev/null 2>&1
if [ $? -ne 0 ]; then
	# ERROR: Permission denied
	echo "Permission denied. Please run as system administrator."
	exit 1
fi
rm -f ${lspath}/noexist

# Initialize directory structure on first load
ls ${lspath}/${dirStr[1]} 1>/dev/null 2>&1
if [ $? -ne 0 ]; then
	mv ${lspath}/${symlinkStr} ${lspath}/${dirStr[1]}
	ln -s ${dirStr[1]} ${lspath}/${symlinkStr} 1>/dev/null 2>&1
	if [ $? -ne 0 ]; then
		# ERROR: Symlink creation failed
		echo "LightScribe installation may be corrupt. Please reinstall."
		exit 1
	fi
fi

# Detect the current contrast setting
prevDir=`ls -l ${lspath}/${symlinkStr} 2>/dev/null`
prevDir=${prevDir:(-4)}
if [ "$prevDir" = "${dirStr[0]}" ]; then
	prevSetting=0
elif [ "$prevDir" = "${dirStr[1]}" ]; then
	prevSetting=1
else
	# ERROR: Symlink did not point to either directory
	echo "LightScribe installation may be corrupt. Please reinstall."
	exit 1
fi

# Output the user prompt
echo "Current contrast setting: "${outputStr[$prevSetting]}
echo
echo "MODIFY CONTRAST SETTINGS:"
echo "1: This will make your labels darker, but you will experience a longer label time"
echo "2: This will reset your LightScribe contrast to default factory settings"
echo -n "Select new setting: "

# Read the user input
read choice
until [ "$choice" = "1" ] || [ "$choice" = "2" ]; do
	echo -n "Invalid input. Retry: "
	read choice
done

# Convert choice to zero-based array index and set directory name
let choice--
newDir=${dirStr[$choice]}

# Apply new settings while watching for failure
applyFailed=0
rm -f ${lspath}/${symlinkStr} 1>/dev/null 2>&1
if [ $? -ne 0 ]; then applyFailed=1; fi
ln -s ${newDir} ${lspath}/${symlinkStr} 1>/dev/null 2>&1
if [ $? -ne 0 ]; then applyFailed=1; fi

# Output results
echo
if [ ${applyFailed} = "0" ]; then
	echo "${outputStr[$choice]} settings applied."
else
	# ERROR: Symlink removal or creation failed for unknown reason
	echo "LightScribe installation may be corrupt. Please reinstall."
	exit 1
fi

exit 0
